set FAB;   # fabricas
set BOD;   # bodegas
set CLI;   # destinos
set PER;   # periodos

# Parametros
param P {FAB} >= 0;	# capacidad maxima de produccion
param M {BOD} >= 0;	# capacidad maxima de almacenaje
param D {CLI,PER} >= 0;	# demanda por tienda por periodo
param C {FAB,PER} >= 0;	# costo unitario de produccion por tienda por periodo
param H {BOD,PER} >= 0;	# costo unitario de almacenamiento por bodega por periodo
param E {FAB,BOD} >= 0;	# costo unitario de transporte de fabrica a bodega
param G {BOD,CLI} >= 0;	# costo unitario de transporte de bodega a cliente

# Variables de Decisin
var x {FAB,BOD,PER} >= 0;	# unidades de fabrica a bodega por periodo
var y {BOD,CLI,PER} >= 0;	# unidades de bodega a cliente por periodo
var w {BOD,PER} >= 0;		# unidades almacenadas en bodega para el prox periodo

# F.O.
minimize costo_total:
	sum {t in PER, j in BOD} (H[j,t]*w[j,t] + sum {i in FAB} (C[i,t]*x[i,j,t] + E[i,j]*x[i,j,t]) + sum{k in CLI} G[j,k]*y[j,k,t]);

# Restricciones
subject to invent1 {j in BOD}:
	w[j,1] = sum {i in FAB} x[i,j,1] - sum {k in CLI} y[j,k,1];

subject to invent6 {j in BOD}:
	w[j,6] = 0;

subject to tienda {j in BOD, t in PER: t>=2}
	sum{k in CLI}y[j,k,t] <= sum{i in FAB}x[i,j,t] + w[j,t-1];

subject to tiendat1 {j in BOD}
	sum{k in CLI}y[j,k,1] <= sum{i in FAB}x[i,j,1];

subject to flujo_inv {j in BOD, t in PER: t>=2}:
	w[j,t] = w[j,t-1] + sum {i in FAB} x[i,j,t] - sum {k in CLI} y[j,k,t];

subject to cap_fab {i in FAB, t in PER}:
	sum {j in BOD} x[i,j,t] <= P[i];

subject to cap_bod {j in BOD, t in PER}:
	w[j,t] <= M[j];

subject to demanda {k in CLI, t in PER}:
	sum {j in BOD} y[j,k,t] >= D[k,t];


